# Einbetten in bestehende Intranetportale

Das Launchpad kann in die eigene Unternehmensseite als iFrame eingebettet werden. Hierzu muss der Pfad zum Launchpad an ein iFrame übergeben werden. Dieser setzt sich aus Servername, Port, WF-Name sowie der App zusammen.

<a
href="http://examle.com:8080/wf-visitor/apps/app/sol.launchpad.apps.Launchpad/">http://examle.com:8080/wf-visitor/apps/app/sol.launchpad.apps.Launchpad/</a>

IFrames unterstützen zudem transparente Hintergründe. Dies wird durch den Parameter `allowtransparency` aktiviert und erlaubt es, das Launchpad auch in Webseiten einzubetten, die eine leichte Hintergrundgrafik einsetzen.

    <iframe 
      src="http://example.com:8080/wf-visitor/apps/app/sol.launchpad.apps.Launchpad?useSSO=true" 
      frameborder="0" 
      style="width: 100%; height: 500px;" 
      allowtransparency="true">
    </iframe><br>
 
## Konfiguration von Single Sign-on

Wenn ELO für Single Sign-on konfiguriert wurde, kann das Launchpad mit den Anmeldedaten gestartet werden.

<a
href="http://example.com:8080/wf-visitor/apps/app/sol.launchpad.apps.Launchpad?useSSO=true">http://example.com:8080/wf-visitor/apps/app/sol.launchpad.apps.Launchpad?useSSO=true</a>

## Standardsprache übergeben

Die im Launchpad verwendete Sprache hängt vom angemeldeten Benutzer ab. Um die Sprache manuell zu ändern, kann zur angegebenen URL noch die Sprache angegeben werden (sofern die Sprache vorhanden ist): 
 <br>
<a
href="http://example.com:8080/wf-visitor/apps/app/sol.launchpad.apps.Launchpad?lang=de">http://example.com:8080/wf-visitor/apps/app/sol.launchpad.apps.Launchpad?lang=de</a>

## Vorhandenes Ticket übergeben

Hat sich ein Benutzer bereits im Client angemeldet, kann eine Sitzung an das Launchpad übergeben werden. In diesem Fall werden jedoch schreibende Zugriffe als solche gezählt. Siehe auch <a
href="#!/guide/pFD1E0AF9_DBD6_419A_8C16_8CDF6B138248">Lizenzhinweise</a>.
 <br>
<a
href="http://example.com:8080/wf-visitor/apps/app/sol.launchpad.apps.Launchpad?ticket=77AF7346D4F70B5C1E40529799095588">http://example.com:8080/wf-visitor/apps/app/sol.launchpad.apps.Launchpad?ticket=77AF7346D4F70B5C1E40529799095588</a>

## Hinweise für die Integration in Microsoft SharePoint

## Microsoft SharePoint setzt im Master-Page-Layout den Komptabilitätsmodus für den Internet Explorer. Hierbei kommt es bei der Authentifizierung über SSO zu einem Fehler in Bezug auf die <span
style='font-weight:bold;font-style:italic'>&quot;Access-Control-Allow-Origin-Header&quot;</span>.

Um das Problem zu lösen muss der Komptabilitätsmodus von SharePoint-Seiten deaktiviert werden. Hierzu kann im Master Page Layout der Seite auf dem das Launchpad eingesetzt wird folgende (ähnliche) Zeile…

    <meta http-equiv="X-UA-Compatible" content="IE=11"/>

…durch IE=edge ersetzt werden. In dem Fall werden für die Ausführung die aktuellste IE-Version eingesetzt.
 
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
<br>
Eine Online-Suche zum Thema &quot;disable Microsoft SharePoint compatibility mode&quot; gibt einen tieferen Einblick in die Thematik. Grundsätzlich sind CORS-Filter für die ordentliche Funktionsweise der ELO Apps notwendig. CORS beschreibt das Teilen von entfernten Ressourcen (Cross-Origin Resource Sharing) und ist ein fester Bestandteil der Sicherheitsarchitektur in modernen Webapplikationen. Alte IE-Versionen unterstützen CORS nicht, dadurch kommt es zu den besagten Fehlern.



